<?php
/**
 * French Language File
 * Contains all language strings for the French version of the site
 */

$lang_data = [
    // General
    'site_name' => 'Web TV Studio',
    'site_description' => 'Services professionnels de diffusion, d\'enregistrement et de streaming au Togo',
    'home' => 'Accueil',
    'about' => 'À Propos',
    'shows' => 'Émissions',
    'team' => 'Équipe',
    'book_studio' => 'Réserver le Studio',
    'booking' => 'Réservation',
    'contact' => 'Contact',
    'login' => 'Connexion',
    'register' => 'Inscription',
    'logout' => 'Déconnexion',
    'my_profile' => 'Mon Profil',
    'my_bookings' => 'Mes Réservations',
    'my_content' => 'Mes Contenus',
    'admin_panel' => 'Panneau d\'Administration',
    'welcome' => 'Bienvenue',
    'close' => 'Fermer',
    'cancel' => 'Annuler',
    'submit' => 'Soumettre',
    'save' => 'Enregistrer',
    'delete' => 'Supprimer',
    'edit' => 'Modifier',
    'view' => 'Voir',
    'search' => 'Rechercher',
    'filter' => 'Filtrer',
    'sort' => 'Trier',
    'all' => 'Tous',
    'back' => 'Retour',
    'next' => 'Suivant',
    'previous' => 'Précédent',
    'view_all' => 'Voir Tout',
    
    // Profile and Account
    'profile_information' => 'Informations du Profil',
    'account_status' => 'Statut du Compte',
    'active' => 'Actif',
    'member_since' => 'Membre depuis',
    'update_profile' => 'Mettre à Jour le Profil',
    'profile_updated' => 'Votre profil a été mis à jour avec succès.',
    'full_name' => 'Nom Complet',
    'email_address' => 'Adresse Email',
    'phone_number' => 'Numéro de Téléphone',
    'no_bookings_yet' => 'Vous n\'avez pas encore de réservations.',
    'no_content_yet' => 'Vous n\'avez pas encore acheté de contenu.',
    'purchased_on' => 'Acheté le',
    'change_password' => 'Changer le Mot de Passe',
    'current_password' => 'Mot de Passe Actuel',
    'new_password' => 'Nouveau Mot de Passe',
    'confirm_password' => 'Confirmer le Mot de Passe',
    'password_min_length' => 'Le mot de passe doit comporter au moins 8 caractères',
    'password_changed' => 'Votre mot de passe a été changé avec succès.',
    
    // Hero Section
    'hero_title' => 'Bienvenue à Notre Studio Web TV',
    'hero_subtitle' => 'Services professionnels de diffusion, d\'enregistrement et de streaming au Togo',
    'explore_shows' => 'Découvrir les Émissions',
    
    // About Section
    'about_title' => 'À Propos de Notre Studio',
    'about_subtitle' => 'Nous offrons des services de production vidéo professionnels avec des équipements de pointe et un personnel expérimenté',
    'professional_equipment' => 'Équipement Professionnel',
    'equipment_text' => 'Caméras, éclairage et équipement sonore de pointe pour garantir une production de haute qualité.',
    'expert_team' => 'Équipe d\'Experts',
    'team_text' => 'Notre équipe expérimentée de producteurs, réalisateurs et techniciens vous aidera à concrétiser votre vision.',
    'global_reach' => 'Portée Mondiale',
    'reach_text' => 'Diffusez votre contenu à un public mondial grâce à nos services de streaming et de distribution.',
    'meet_our_team' => 'Rencontrer Notre Équipe',
    
    // Shows Section
    'shows_title' => 'Nos Émissions',
    'shows_subtitle' => 'Parcourez notre collection de programmes originaux et de productions clients',
    'no_shows' => 'Aucune émission disponible pour le moment.',
    'watch_now' => 'Regarder Maintenant',
    'view_all_shows' => 'Voir Toutes les Émissions',
    
    // Team Section
    'team_title' => 'Notre Équipe',
    'team_subtitle' => 'Rencontrez les professionnels qui donneront vie à votre vision',
    'view_full_team' => 'Voir l\'Équipe Complète',
    
    // Booking Section
    'booking_title' => 'Réserver Notre Studio',
    'booking_subtitle' => 'Réservez notre studio professionnel pour votre prochaine production',
    'booking_form' => 'Formulaire de Réservation',
    'make_booking' => 'Faire une Réservation',
    'view_availability' => 'Voir la Disponibilité',
    'preferred_date' => 'Date Préférée',
    'preferred_time' => 'Heure Préférée',
    'select_time' => 'Sélectionner l\'Heure',
    'no_slots_available' => 'Aucun créneau disponible pour cette date',
    'service_type' => 'Type de Service',
    'select_service' => 'Sélectionner le Service',
    'additional_info' => 'Informations Supplémentaires',
    'payment_method' => 'Méthode de Paiement',
    'submit_booking' => 'Soumettre la Réservation',
    'booking_summary' => 'Résumé de la Réservation',
    'service' => 'Service',
    'date_and_time' => 'Date et Heure',
    'total' => 'Total',
    'available_slots' => 'Créneaux Disponibles',
    
    // Services Section
    'services_title' => 'Nos Services',
    'services_subtitle' => 'Services de production professionnels adaptés à vos besoins',
    'talk_show' => 'Talk Show',
    'talk_show_text' => 'Production professionnelle de talk-show avec plusieurs angles de caméra.',
    'music_video' => 'Clip Vidéo',
    'music_video_text' => 'Production professionnelle de clips vidéo avec réalisation, tournage et montage.',
    'interview' => 'Interview',
    'interview_text' => 'Enregistrement professionnel d\'interviews avec éclairage, son et montage.',
    'podcast' => 'Podcast',
    'podcast_text' => 'Enregistrement et montage professionnels de podcasts.',
    'live_streaming' => 'Diffusion en Direct',
    'live_streaming_text' => 'Service professionnel de diffusion en direct pour votre événement ou émission.',
    'book_now' => 'Réserver Maintenant',
    
    // Contact Section
    'contact_title' => 'Contactez-Nous',
    'contact_subtitle' => 'Prenez contact avec nous pour toute demande ou pour discuter de votre projet',
    'get_in_touch' => 'Entrer en Contact',
    'contact_description' => 'Vous avez des questions ou besoin de plus d\'informations? Contactez-nous directement via ce formulaire ou en utilisant les informations ci-dessous.',
    'your_name' => 'Votre Nom',
    'subject' => 'Sujet',
    'message' => 'Message',
    'send_message' => 'Envoyer le Message',
    'address' => 'Adresse',
    'phone' => 'Téléphone',
    'email' => 'Email',
    
    // User Dashboard
    'account_dashboard' => 'Tableau de Bord du Compte',
    'booking_history' => 'Historique des Réservations',
    'upcoming_bookings' => 'Réservations à Venir',
    'past_bookings' => 'Réservations Passées',
    'purchased_content' => 'Contenu Acheté',
    'payment_history' => 'Historique des Paiements',
    'account_settings' => 'Paramètres du Compte',
    'notifications' => 'Notifications',
    'no_payments_yet' => 'Vous n\'avez pas encore d\'historique de paiement.',
    
    // Footer
    'footer_description' => 'Studio web TV professionnel offrant des services de diffusion, d\'enregistrement et de streaming de haute qualité au Togo.',
    'quick_links' => 'Liens Rapides',
    'our_services' => 'Nos Services',
    'working_hours' => 'Heures d\'Ouverture',
    'monday_friday' => 'Lundi - Vendredi: 9h - 19h',
    'saturday' => 'Samedi: 10h - 16h',
    'sunday' => 'Dimanche: Fermé',
    'newsletter' => 'Newsletter',
    'newsletter_text' => 'Abonnez-vous à notre newsletter pour recevoir des mises à jour et des offres spéciales.',
    'subscribe' => 'S\'abonner',
    'enter_email' => 'Entrez votre email',
    'all_rights_reserved' => 'Tous Droits Réservés.',
    'privacy_policy' => 'Politique de Confidentialité',
    'terms_conditions' => 'Conditions Générales',
    
    // Payment
    'complete_payment' => 'Compléter le Paiement',
    'pay_with_flooz' => 'Payer avec Flooz',
    'pay_with_tmoney' => 'Payer avec T-Money',
    'to_complete_booking' => 'Pour compléter votre réservation, veuillez envoyer le paiement à :',
    'amount' => 'Montant',
    'once_payment_sent' => 'Une fois que vous avez envoyé le paiement, entrez l\'ID de transaction ci-dessous :',
    'transaction_id' => 'ID de Transaction',
    'confirm_payment' => 'Confirmer le Paiement',
    'confirm_payment_button' => 'Confirmer le Paiement',
    'booking_confirmation' => 'Confirmation de Réservation',
    'thank_you' => 'Merci !',
    'booking_confirmed_message' => 'Votre réservation a été confirmée. Vous recevrez bientôt une confirmation par SMS et par email.',
    'booking_reference' => 'Référence de Réservation',
    'date' => 'Date',
    'time' => 'Heure',
    
    // Status words
    'pending' => 'En Attente',
    'confirmed' => 'Confirmé',
    'completed' => 'Terminé',
    'canceled' => 'Annulé',
    'paid' => 'Payé',
    'unpaid' => 'Non Payé',
    'partial' => 'Partiel',
    'refunded' => 'Remboursé',
    
    // Admin Dashboard
    'admin_dashboard' => 'Tableau de Bord Admin',
    'dashboard' => 'Tableau de Bord',
    'bookings' => 'Réservations',
    'payments' => 'Paiements',
    'content' => 'Contenu',
    'users' => 'Utilisateurs',
    'settings' => 'Paramètres',
    'analytics' => 'Analyses',
    'reports' => 'Rapports',
    'services' => 'Services',
    'categories' => 'Catégories',
    'comments' => 'Commentaires',
    'messages' => 'Messages',
    'logs' => 'Journaux',
    'system' => 'Système',
    
    'total_bookings' => 'Réservations Totales',
    'revenue' => 'Revenus',
    'content_views' => 'Vues du Contenu',
    'since_last_month' => 'depuis le mois dernier',
    'export' => 'Exporter',
    'print' => 'Imprimer',
    'today' => 'Aujourd\'hui',
    'this_week' => 'Cette Semaine',
    'this_month' => 'Ce Mois',
    'this_year' => 'Cette Année',
    'all_time' => 'Tout',
    'monthly' => 'Mensuel',
    'weekly' => 'Hebdomadaire',
    'daily' => 'Quotidien',
    
    'bookings_revenue_overview' => 'Aperçu des Réservations et Revenus',
    'service_distribution' => 'Distribution des Services',
    'recent_bookings' => 'Réservations Récentes',
    'reference' => 'Référence',
    'client' => 'Client',
    'date_time' => 'Date et Heure',
    'status' => 'Statut',
    'actions' => 'Actions',
    'no_bookings' => 'Aucune réservation trouvée',
    
    'recent_activities' => 'Activités Récentes',
    'booking_calendar' => 'Calendrier des Réservations',
    'popular_content' => 'Contenu Populaire',
    'no_content' => 'Aucun contenu trouvé',
    'no_recent_activities' => 'Aucune activité récente',
    'views' => 'vues',
    
    'new_booking_from' => 'Nouvelle réservation de',
    'payment_received' => 'Paiement reçu de',
    'seconds_ago' => 'secondes',
    'minutes_ago' => 'minutes',
    'hours_ago' => 'heures',
    'days_ago' => 'jours',
    
    'export_started' => 'L\'exportation des données a commencé. Votre fichier sera bientôt prêt à être téléchargé.',
    'admin_version' => 'Version Admin',
    'need_help' => 'Besoin d\'Aide?',
    'confirm_action' => 'Confirmer l\'Action',
    'confirm_action_message' => 'Êtes-vous sûr de vouloir effectuer cette action?',
    'confirm' => 'Confirmer',
    'notification' => 'Notification',
    
    // Calendar
    'calendar_today' => 'Aujourd\'hui',
    'calendar_month' => 'Mois',
    'calendar_week' => 'Semaine',
    'calendar_day' => 'Jour',
    'calendar_list' => 'Liste',
    
    // Form validation messages
    'field_required' => 'Ce champ est requis',
    'valid_email' => 'Veuillez entrer une adresse email valide',
    'valid_phone' => 'Veuillez entrer un numéro de téléphone valide',
    'passwords_dont_match' => 'Les mots de passe ne correspondent pas',
    'agree_to_terms' => 'Vous devez accepter les Conditions Générales',
    
    // Success messages
    'booking_success' => 'Votre réservation a été soumise avec succès. Nous vous contacterons bientôt pour confirmer votre réservation.',
    'contact_success' => 'Votre message a été envoyé avec succès. Nous vous répondrons bientôt.',
    'login_success' => 'Vous vous êtes connecté avec succès.',
    'register_success' => 'Votre compte a été créé avec succès. Vous pouvez maintenant vous connecter.',
    'logout_success' => 'Vous vous êtes déconnecté avec succès.',
    
    // Error messages
    'booking_error' => 'Il y a eu une erreur lors du traitement de votre réservation. Veuillez réessayer.',
    'contact_error' => 'Il y a eu une erreur lors de l\'envoi de votre message. Veuillez réessayer.',
    'login_error' => 'Email ou mot de passe invalide. Veuillez réessayer.',
    'register_error' => 'Il y a eu une erreur lors de la création de votre compte. Veuillez réessayer.',
    
    // Login/Register
    'login_title' => 'Connexion à Votre Compte',
    'welcome_back' => 'Bienvenue !',
    'login_message' => 'Connectez-vous pour accéder à vos réservations, achats et plus encore.',
    'remember_me' => 'Se Souvenir de Moi',
    'forgot_password' => 'Mot de Passe Oublié ?',
    'dont_have_account' => 'Vous n\'avez pas de compte ?',
    'create_account' => 'Créer un Compte',
    
    'register_title' => 'Créer un Compte',
    'register_message' => 'Créez un compte pour réserver notre studio et accéder à du contenu premium.',
    'agree_terms' => 'J\'accepte les Conditions Générales',
    'already_have_account' => 'Vous avez déjà un compte ?',
    
    // Miscellaneous
    'copyright' => 'Tous Droits Réservés',
    'terms' => 'Conditions Générales',
    'privacy' => 'Politique de Confidentialité',
    'faq' => 'FAQ',
    'back_to_top' => 'Retour en Haut',
    'learn_more' => 'En Savoir Plus',
    'read_more' => 'Lire Plus',
    'loading' => 'Chargement...',
    'page' => 'Page',
    'of' => 'sur',
    'first' => 'Premier',
    'last' => 'Dernier',
    'showing' => 'Affichage de',
    'entries' => 'entrées',
    'no_results' => 'Aucun résultat trouvé',
    'results' => 'résultats',
    'found' => 'trouvés',
    'create_new' => 'Créer Nouveau',
    'add_new' => 'Ajouter Nouveau',
    'update' => 'Mettre à Jour',
    'details' => 'Détails',
    'profile' => 'Profil',
    'password' => 'Mot de Passe',
    'reset_password' => 'Réinitialiser le Mot de Passe',
    'mobile_money' => 'Mobile Money',
];