<?php
/**
 * English Language File - Complete with User Navigation
 */

$lang_data = [
    // General
    'site_name' => 'Web TV Studio',
    'welcome' => 'Welcome',
    'home' => 'Home',
    'about' => 'About',
    'shows' => 'Shows',
    'team' => 'Team',
    'contact' => 'Contact',
    'login' => 'Login',
    'register' => 'Register',
    'logout' => 'Logout',
    'book_studio' => 'Book Studio',
    'view_all' => 'View All',
    
    // User Navigation
    'my_profile' => 'My Profile',
    'my_bookings' => 'My Bookings',
    'my_content' => 'My Content',
    'dashboard' => 'Dashboard',
    'admin_panel' => 'Admin Panel',
    
    // Profile and Account
    'profile_information' => 'Profile Information',
    'account_status' => 'Account Status',
    'active' => 'Active',
    'member_since' => 'Member Since',
    'update_profile' => 'Update Profile',
    'profile_updated' => 'Your profile has been updated successfully.',
    'full_name' => 'Full Name',
    'email_address' => 'Email Address',
    'phone_number' => 'Phone Number',
    'no_bookings_yet' => 'You have no bookings yet.',
    'no_content_yet' => 'You have not purchased any content yet.',
    'purchased_on' => 'Purchased on',
    'change_password' => 'Change Password',
    'current_password' => 'Current Password',
    'new_password' => 'New Password',
    'confirm_password' => 'Confirm Password',
    'password_min_length' => 'Password must be at least 8 characters long',
    'password_changed' => 'Your password has been changed successfully.',
    
    // Hero Section
    'hero_title' => 'Welcome to Our Web TV Studio',
    'hero_subtitle' => 'Professional broadcasting, recording and streaming services in Togo',
    'explore_shows' => 'Explore Shows',
    
    // About Section
    'about_title' => 'About Our Studio',
    'about_subtitle' => 'We provide professional video production services with state-of-the-art equipment and experienced staff',
    'professional_equipment' => 'Professional Equipment',
    'equipment_text' => 'State-of-the-art cameras, lighting, and sound equipment to ensure high-quality production.',
    'expert_team' => 'Expert Team',
    'team_text' => 'Our experienced team of producers, directors, and technicians will help bring your vision to life.',
    'global_reach' => 'Global Reach',
    'reach_text' => 'Broadcast your content to a worldwide audience with our streaming and distribution services.',
    'meet_our_team' => 'Meet Our Team',
    
    // Shows Section
    'shows_title' => 'Our Shows',
    'shows_subtitle' => 'Browse our collection of original programming and client productions',
    'no_shows' => 'No shows available at the moment.',
    'watch_now' => 'Watch Now',
    'view_all_shows' => 'View All Shows',
    
    // Services Section
    'services_title' => 'Our Services',
    'services_subtitle' => 'Professional production services tailored to your needs',
    'talk_show' => 'Talk Show',
    'talk_show_text' => 'Professional talk show production with multiple camera angles.',
    'music_video' => 'Music Video',
    'music_video_text' => 'Professional music video production with direction, filming, and editing.',
    'interview' => 'Interview',
    'interview_text' => 'Professional interview recording with lighting, sound, and editing.',
    'podcast' => 'Podcast',
    'podcast_text' => 'Professional podcast recording and editing.',
    'live_streaming' => 'Live Streaming',
    'live_streaming_text' => 'Professional live streaming service for your event or show.',
    'book_now' => 'Book Now',
    
    // Team Section
    'team_title' => 'Our Team',
    'team_subtitle' => 'Meet the professionals who will bring your vision to life',
    'view_full_team' => 'View Full Team',
    
    // Booking Section
    'booking_title' => 'Book Our Studio',
    'booking_subtitle' => 'Reserve our professional studio for your next production',
    'booking_form' => 'Booking Form',
    'make_booking' => 'Make a Booking',
    'view_availability' => 'View Availability',
    'preferred_date' => 'Preferred Date',
    'preferred_time' => 'Preferred Time',
    'service_type' => 'Service Type',
    'additional_info' => 'Additional Information',
    'payment_method' => 'Payment Method',
    'submit_booking' => 'Submit Booking',
    'booking_summary' => 'Booking Summary',
    'service' => 'Service',
    'date_and_time' => 'Date and Time',
    'total' => 'Total',
    'select_service' => 'Select a service',
    'select_time' => 'Select a time slot',
    'no_slots_available' => 'No slots available for this date',
    'available_slots' => 'Available Time Slots',
    'booking' => 'Booking',
    
    // Testimonials Section
    'testimonials_title' => 'What Our Clients Say',
    'testimonials_subtitle' => 'Hear from our satisfied clients about their experience with our studio',
    
    // Contact Section
    'contact_title' => 'Contact Us',
    'contact_subtitle' => 'Get in touch with us for any inquiries or to discuss your project',
    'your_name' => 'Your Name',
    'subject' => 'Subject',
    'message' => 'Message',
    'send_message' => 'Send Message',
    'get_in_touch' => 'Get In Touch',
    'contact_description' => 'We would love to hear from you. Feel free to reach out for any information or to discuss your next project.',
    'address' => 'Address',
    'phone' => 'Phone',
    'email' => 'Email',
    
    // User Dashboard
    'account_dashboard' => 'Account Dashboard',
    'booking_history' => 'Booking History',
    'upcoming_bookings' => 'Upcoming Bookings',
    'past_bookings' => 'Past Bookings',
    'purchased_content' => 'Purchased Content',
    'payment_history' => 'Payment History',
    'account_settings' => 'Account Settings',
    'notifications' => 'Notifications',
    'no_payments_yet' => 'You have no payment history yet.',
    
    // Footer Section
    'footer_description' => 'We are a professional TV studio offering high-quality broadcasting, recording, and streaming services in Togo.',
    'quick_links' => 'Quick Links',
    'our_services' => 'Our Services',
    'working_hours' => 'Working Hours',
    'monday_friday' => 'Monday - Friday: 9:00 AM - 7:00 PM',
    'saturday' => 'Saturday: 10:00 AM - 4:00 PM',
    'sunday' => 'Sunday: Closed',
    'newsletter' => 'Newsletter',
    'newsletter_text' => 'Subscribe to our newsletter to receive updates and special offers.',
    'subscribe' => 'Subscribe',
    'enter_email' => 'Enter your email',
    'all_rights_reserved' => 'All rights reserved',
    'privacy_policy' => 'Privacy Policy',
    'terms_conditions' => 'Terms & Conditions',
    
    // Admin Dashboard
    'admin_dashboard' => 'Admin Dashboard',
    'print' => 'Print',
    'export' => 'Export',
    'this_month' => 'This Month',
    'today' => 'Today',
    'this_week' => 'This Week',
    'this_year' => 'This Year',
    'all_time' => 'All Time',
    'total_bookings' => 'Total Bookings',
    'revenue' => 'Revenue',
    'content_views' => 'Content Views',
    'users' => 'Users',
    'since_last_month' => 'Since Last Month',
    'bookings_revenue_overview' => 'Bookings & Revenue Overview',
    'monthly' => 'Monthly',
    'weekly' => 'Weekly',
    'service_distribution' => 'Service Distribution',
    'recent_bookings' => 'Recent Bookings',
    'reference' => 'Reference',
    'client' => 'Client',
    'date_time' => 'Date & Time',
    'status' => 'Status',
    'actions' => 'Actions',
    'no_bookings' => 'No bookings found.',
    'recent_activities' => 'Recent Activities',
    'new_booking_from' => 'New booking from',
    'payment_received' => 'Payment received from',
    'no_recent_activities' => 'No recent activities.',
    'seconds_ago' => 'seconds ago',
    'minutes_ago' => 'minutes ago',
    'hours_ago' => 'hours ago',
    'days_ago' => 'days ago',
    'booking_calendar' => 'Booking Calendar',
    'popular_content' => 'Popular Content',
    'no_content' => 'No content found.',
    'views' => 'views',
    'export_started' => 'Export process has started. Your file will be ready for download shortly.',
    'admin_version' => 'Admin Version',
    'need_help' => 'Need Help?',
    'confirm_action' => 'Confirm Action',
    'confirm_action_message' => 'Are you sure you want to perform this action?',
    'cancel' => 'Cancel',
    'confirm' => 'Confirm',
    'notification' => 'Notification',
    
    // Status words
    'pending' => 'Pending',
    'confirmed' => 'Confirmed',
    'completed' => 'Completed',
    'canceled' => 'Canceled',
    
    // Form validation messages
    'field_required' => 'This field is required',
    'valid_email' => 'Please enter a valid email address',
    'valid_phone' => 'Please enter a valid phone number',
    'passwords_dont_match' => 'Passwords do not match',
    'agree_to_terms' => 'You must agree to the Terms and Conditions',
    
    // Success messages
    'booking_success' => 'Your booking has been submitted successfully. We will contact you shortly to confirm your reservation.',
    'contact_success' => 'Your message has been sent successfully. We will get back to you soon.',
    'login_success' => 'You have been logged in successfully.',
    'register_success' => 'Your account has been created successfully. You can now login.',
    'logout_success' => 'You have been logged out successfully.',
    
    // Error messages
    'booking_error' => 'There was an error processing your booking. Please try again.',
    'contact_error' => 'There was an error sending your message. Please try again.',
    'login_error' => 'Invalid email or password. Please try again.',
    'register_error' => 'There was an error creating your account. Please try again.',
    
    // Miscellaneous
    'copyright' => 'All rights reserved',
    'terms' => 'Terms & Conditions',
    'privacy' => 'Privacy Policy',
    'faq' => 'FAQ',
    'back_to_top' => 'Back to Top',
    'close' => 'Close',
    'save' => 'Save',
    'delete' => 'Delete',
    'edit' => 'Edit',
    'learn_more' => 'Learn More',
    'read_more' => 'Read More',
    'loading' => 'Loading...',
    'search' => 'Search',
    'filter' => 'Filter',
    'sort' => 'Sort',
    'page' => 'Page',
    'of' => 'of',
    'next' => 'Next',
    'previous' => 'Previous',
    'first' => 'First',
    'last' => 'Last',
    'showing' => 'Showing',
    'entries' => 'entries',
    'no_results' => 'No results found',
    'results' => 'results',
    'found' => 'found',
    'create_new' => 'Create New',
    'add_new' => 'Add New',
    'update' => 'Update',
    'details' => 'Details',
    'settings' => 'Settings',
    'profile' => 'Profile',
    'password' => 'Password',
    'reset_password' => 'Reset Password',
    'remember_me' => 'Remember Me',
    'dont_have_account' => 'Don\'t have an account?',
    'already_have_account' => 'Already have an account?',
    'create_account' => 'Create Account',
    'register_title' => 'Register',
    'register_message' => 'Create an account to book our studio and access premium content.',
    'login_title' => 'Login',
    'welcome_back' => 'Welcome Back!',
    'login_message' => 'Login to access your account.',
    'agree_terms' => 'I agree to the Terms and Conditions',
    'forgot_password' => 'Forgot Password?',
];