<?php
/**
 * Footer Template
 * The footer section displayed on all site pages
 */
?>

<footer class="footer">
    <div class="container">
        <div class="row">
            <!-- Footer Logo & Description -->
            <div class="col-lg-3 col-md-6 mb-4 mb-lg-0">
                <div class="footer-logo">
                    <img src="assets/images/logo-white.png" alt="<?php echo SITE_NAME; ?>" class="img-fluid">
                </div>
                <p class="mt-3 mb-4"><?php echo $lang_data['footer_description']; ?></p>
                <div class="footer-social">
                    <a href="#" aria-label="Facebook"><i class="fab fa-facebook-f"></i></a>
                    <a href="#" aria-label="Twitter"><i class="fab fa-twitter"></i></a>
                    <a href="#" aria-label="Instagram"><i class="fab fa-instagram"></i></a>
                    <a href="#" aria-label="YouTube"><i class="fab fa-youtube"></i></a>
                    <a href="#" aria-label="LinkedIn"><i class="fab fa-linkedin-in"></i></a>
                </div>
            </div>

            <!-- Quick Links -->
            <div class="col-lg-3 col-md-6 mb-4 mb-lg-0">
                <h4><?php echo $lang_data['quick_links']; ?></h4>
                <ul class="footer-links">
                    <li><a href="index.php"><?php echo $lang_data['home']; ?></a></li>
                    <li><a href="about.php"><?php echo $lang_data['about']; ?></a></li>
                    <li><a href="shows.php"><?php echo $lang_data['shows']; ?></a></li>
                    <li><a href="team.php"><?php echo $lang_data['team']; ?></a></li>
                    <li><a href="book-studio.php"><?php echo $lang_data['booking']; ?></a></li>
                    <li><a href="contact.php"><?php echo $lang_data['contact']; ?></a></li>
                </ul>
            </div>

            <!-- Our Services -->
            <div class="col-lg-3 col-md-6 mb-4 mb-lg-0">
                <h4><?php echo $lang_data['our_services']; ?></h4>
                <ul class="footer-links">
                    <li><a href="service.php?id=1"><?php echo $lang_data['talk_show']; ?></a></li>
                    <li><a href="service.php?id=2"><?php echo $lang_data['music_video']; ?></a></li>
                    <li><a href="service.php?id=3"><?php echo $lang_data['interview']; ?></a></li>
                    <li><a href="service.php?id=4"><?php echo $lang_data['podcast']; ?></a></li>
                    <li><a href="service.php?id=5"><?php echo $lang_data['live_streaming']; ?></a></li>
                </ul>
            </div>

            <!-- Working Hours & Contact -->
            <div class="col-lg-3 col-md-6">
                <h4><?php echo $lang_data['working_hours']; ?></h4>
                <ul class="footer-info">
                    <li><i class="far fa-clock"></i> <?php echo $lang_data['monday_friday']; ?></li>
                    <li><i class="far fa-clock"></i> <?php echo $lang_data['saturday']; ?></li>
                    <li><i class="far fa-clock"></i> <?php echo $lang_data['sunday']; ?></li>
                </ul>

                <h4 class="mt-4"><?php echo $lang_data['newsletter']; ?></h4>
                <p><?php echo $lang_data['newsletter_text']; ?></p>
                <form class="newsletter-form" action="process-newsletter.php" method="post">
                    <div class="input-group">
                        <input type="email" class="form-control" name="email" placeholder="<?php echo $lang_data['enter_email']; ?>" required>
                        <button class="btn btn-primary" type="submit"><?php echo $lang_data['subscribe']; ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="copyright">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <p>&copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. <?php echo $lang_data['all_rights_reserved']; ?></p>
                </div>
                <div class="col-md-6 text-md-end">
                    <a href="privacy-policy.php"><?php echo $lang_data['privacy_policy']; ?></a>
                    <span class="mx-2">|</span>
                    <a href="terms-conditions.php"><?php echo $lang_data['terms_conditions']; ?></a>
                </div>
            </div>
        </div>
    </div>
</footer>

<!-- Back to Top Button -->
<div class="back-to-top">
    <i class="fas fa-chevron-up"></i>
</div>

<!-- JavaScript Files -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/chart.js@3.7.1/dist/chart.min.js"></script>
<script src="assets/js/main.js"></script>

<?php if (strpos($_SERVER['PHP_SELF'], 'booking') !== false || strpos($_SERVER['PHP_SELF'], 'book-studio') !== false): ?>
<script src="assets/js/booking.js"></script>
<?php endif; ?>

<?php if (strpos($_SERVER['PHP_SELF'], 'index') !== false): ?>
<script src="assets/js/animations.js"></script>
<?php endif; ?>

<?php
// Define a constant to indicate the footer is included
define('FOOTER_INCLUDED', true);
?>