<?php
/**
 * Admin Sidebar Navigation
 */

// Get current page to highlight active menu item
$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>

<nav id="sidebar" class="col-md-3 col-lg-2 d-md-block bg-dark sidebar collapse">
    <div class="position-sticky pt-3">
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo ($currentPage == 'index') ? 'active' : ''; ?>" href="index.php">
                    <i class="fas fa-tachometer-alt me-2"></i>
                    <span><?php echo $lang_data['dashboard']; ?></span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?php echo ($currentPage == 'bookings' || $currentPage == 'booking-details') ? 'active' : ''; ?>" href="bookings.php">
                    <i class="fas fa-calendar-alt me-2"></i>
                    <span><?php echo $lang_data['bookings']; ?></span>
                    <?php
                    // Count pending bookings
                    $pendingBookingsCount = $db->getValue(
                        "SELECT COUNT(*) FROM bookings WHERE status = 'pending'"
                    );
                    
                    if ($pendingBookingsCount > 0):
                    ?>
                        <span class="badge bg-danger ms-2"><?php echo $pendingBookingsCount; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?php echo ($currentPage == 'payments') ? 'active' : ''; ?>" href="payments.php">
                    <i class="fas fa-credit-card me-2"></i>
                    <span><?php echo $lang_data['payments']; ?></span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?php echo (in_array($currentPage, ['content', 'content-details', 'add-content', 'edit-content', 'categories'])) ? 'active' : ''; ?>" 
                   data-bs-toggle="collapse" href="#contentSubmenu" role="button" 
                   aria-expanded="<?php echo (in_array($currentPage, ['content', 'content-details', 'add-content', 'edit-content', 'categories'])) ? 'true' : 'false'; ?>" 
                   aria-controls="contentSubmenu">
                    <i class="fas fa-tv me-2"></i>
                    <span><?php echo $lang_data['content']; ?></span>
                    <i class="fas fa-chevron-down ms-auto small"></i>
                </a>
                <div class="collapse <?php echo (in_array($currentPage, ['content', 'content-details', 'add-content', 'edit-content', 'categories'])) ? 'show' : ''; ?>" id="contentSubmenu">
                    <ul class="nav flex-column ms-3">
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($currentPage == 'content') ? 'active' : ''; ?>" href="content.php">
                                <i class="fas fa-list me-2"></i> <?php echo $lang_data['all_content']; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($currentPage == 'add-content') ? 'active' : ''; ?>" href="add-content.php">
                                <i class="fas fa-plus me-2"></i> <?php echo $lang_data['add_content']; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($currentPage == 'categories') ? 'active' : ''; ?>" href="categories.php">
                                <i class="fas fa-folder me-2"></i> <?php echo $lang_data['categories']; ?>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link <?php echo ($currentPage == 'comments') ? 'active' : ''; ?>" href="comments.php">
                                <i class="fas fa-comments me-2"></i> <?php echo $lang_data['comments']; ?>
                                <?php
                                // Count pending comments
                                $pendingCommentsCount = $db->getValue(
                                    "SELECT COUNT(*) FROM comments WHERE status = 'pending'"
                                );
                                
                                if ($pendingCommentsCount > 0):
                                ?>
                                    <span class="badge bg-danger ms-2"><?php echo $pendingCommentsCount; ?></span>
                                <?php endif; ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?php echo ($currentPage == 'services') ? 'active' : ''; ?>" href="services.php">
                    <i class="fas fa-film me-2"></i>
                    <span><?php echo $lang_data['services']; ?></span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?php echo ($currentPage == 'users') ? 'active' : ''; ?>" href="users.php">
                    <i class="fas fa-users me-2"></i>
                    <span><?php echo $lang_data['users']; ?></span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?php echo ($currentPage == 'messages') ? 'active' : ''; ?>" href="messages.php">
                    <i class="fas fa-envelope me-2"></i>
                    <span><?php echo $lang_data['messages']; ?></span>
                    <?php
                    // Count unread messages
                    $unreadMessagesCount = $db->getValue(
                        "SELECT COUNT(*) FROM messages WHERE is_read = 0"
                    );
                    
                    if ($unreadMessagesCount > 0):
                    ?>
                        <span class="badge bg-danger ms-2"><?php echo $unreadMessagesCount; ?></span>
                    <?php endif; ?>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?php echo ($currentPage == 'newsletter') ? 'active' : ''; ?>" href="newsletter.php">
                    <i class="fas fa-paper-plane me-2"></i>
                    <span><?php echo $lang_data['newsletter']; ?></span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?php echo ($currentPage == 'reports') ? 'active' : ''; ?>" href="reports.php">
                    <i class="fas fa-chart-bar me-2"></i>
                    <span><?php echo $lang_data['reports']; ?></span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?php echo ($currentPage == 'settings') ? 'active' : ''; ?>" href="settings.php">
                    <i class="fas fa-cog me-2"></i>
                    <span><?php echo $lang_data['settings']; ?></span>
                </a>
            </li>
        </ul>
        
        <h6 class="sidebar-heading d-flex justify-content-between align-items-center px-3 mt-4 mb-1 text-muted">
            <span><?php echo $lang_data['admin_shortcuts']; ?></span>
        </h6>
        
        <ul class="nav flex-column mb-2">
            <li class="nav-item">
                <a class="nav-link" href="../index.php" target="_blank">
                    <i class="fas fa-external-link-alt me-2"></i>
                    <span><?php echo $lang_data['view_website']; ?></span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="profile.php">
                    <i class="fas fa-user me-2"></i>
                    <span><?php echo $lang_data['my_profile']; ?></span>
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link" href="logout.php">
                    <i class="fas fa-sign-out-alt me-2"></i>
                    <span><?php echo $lang_data['logout']; ?></span>
                </a>
            </li>
        </ul>
    </div>
</nav>
