<?php
/**
 * Admin Header
 * Contains the header section for all admin pages
 */

// Check if this file is included directly
if (!defined('ADMIN_ACCESS')) {
    header('Location: ../index.php');
    exit;
}

// Initialize variables for notifications
$notificationCount = 0;
$notifications = [];

// Safely get notification count - with error handling
try {
    $db = Database::getInstance();
    
    // First check if the notifications table exists
    $tableExists = false;
    try {
        $tableCheck = $db->getRow("SHOW TABLES LIKE 'notifications'");
        $tableExists = !empty($tableCheck);
    } catch (Exception $e) {
        // Table doesn't exist or can't be accessed
        error_log("Notifications table check failed: " . $e->getMessage());
    }
    
    // Only get notifications if the table exists
    if ($tableExists) {
        try {
            $notificationCount = $db->getValue(
                "SELECT COUNT(*) FROM notifications WHERE is_read = 0 AND (user_id IS NULL OR user_id = ?)",
                [$currentUser['id']]
            ) ?: 0;
            
            // Get recent unread notifications
            $notifications = $db->getRows(
                "SELECT * FROM notifications 
                WHERE is_read = 0 AND (user_id IS NULL OR user_id = ?) 
                ORDER BY created_at DESC LIMIT 5",
                [$currentUser['id']]
            ) ?: [];
        } catch (Exception $e) {
            // Query failed but we'll continue
            error_log("Notifications query failed: " . $e->getMessage());
            $notificationCount = 0;
            $notifications = [];
        }
    }
} catch (Exception $e) {
    // Something went wrong but we'll continue
    error_log("Error in admin header: " . $e->getMessage());
    $notificationCount = 0;
    $notifications = [];
}
?>
<!DOCTYPE html>
<html lang="<?php echo $lang; ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $pageTitle; ?></title>
    
    <!-- Favicon -->
    <link rel="shortcut icon" href="../assets/images/favicon.ico" type="image/x-icon">
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    
    <!-- DataTables -->
    <link href="https://cdn.datatables.net/1.13.5/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    
    <!-- Summernote -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-bs5.min.css" rel="stylesheet">
    
    <!-- Custom Admin CSS -->
    <link href="../css/admin.css" rel="stylesheet">
    
    <?php if (isset($additionalCss)): ?>
        <?php foreach ($additionalCss as $css): ?>
            <link href="<?php echo $css; ?>" rel="stylesheet">
        <?php endforeach; ?>
    <?php endif; ?>
</head>
<body>
    <!-- Admin Header -->
    <header class="navbar navbar-dark sticky-top bg-dark flex-md-nowrap p-0 shadow">
        <a class="navbar-brand col-md-3 col-lg-2 me-0 px-3" href="index.php">
            <img src="../assets/images/logo-white.png" alt="<?php echo SITE_NAME; ?>" height="30">
        </a>
        <button class="navbar-toggler position-absolute d-md-none collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu" aria-controls="sidebarMenu" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="w-100 d-none d-md-block"></div>
        
        <div class="navbar-nav flex-row">
            <!-- Language Switcher -->
            <li class="nav-item dropdown">
                <button class="nav-link dropdown-toggle px-3 border-0 bg-transparent" type="button" id="languageDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="fas fa-globe me-1"></i>
                    <?php echo strtoupper($lang); ?>
                </button>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="languageDropdown">
                    <li><a class="dropdown-item <?php echo ($lang === 'en') ? 'active' : ''; ?>" href="?language=en">English</a></li>
                    <li><a class="dropdown-item <?php echo ($lang === 'fr') ? 'active' : ''; ?>" href="?language=fr">Français</a></li>
                </ul>
            </li>
            
            <!-- Notifications -->
            <li class="nav-item dropdown">
                <button class="nav-link dropdown-toggle px-3 border-0 bg-transparent" type="button" id="notificationsDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="fas fa-bell"></i>
                    <?php if ($notificationCount > 0): ?>
                        <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger">
                            <?php echo $notificationCount; ?>
                            <span class="visually-hidden"><?php echo $lang_data['unread_notifications']; ?></span>
                        </span>
                    <?php endif; ?>
                </button>
                <ul class="dropdown-menu dropdown-menu-end notification-dropdown" aria-labelledby="notificationsDropdown">
                    <li><h6 class="dropdown-header"><?php echo $lang_data['notifications']; ?></h6></li>
                    
                    <?php if (empty($notifications)): ?>
                        <li><div class="dropdown-item text-muted"><?php echo $lang_data['no_notifications']; ?></div></li>
                    <?php else: ?>
                        <?php foreach ($notifications as $notification): ?>
                            <li>
                                <a class="dropdown-item d-flex align-items-center" href="<?php echo $notification['link'] ?? '#'; ?>">
                                    <div class="me-3">
                                        <div class="notification-icon bg-primary">
                                            <i class="fas fa-<?php echo $notification['icon'] ?? 'bell'; ?>"></i>
                                        </div>
                                    </div>
                                    <div>
                                        <div class="small text-muted"><?php echo date('M j, Y g:i A', strtotime($notification['created_at'])); ?></div>
                                        <div><?php echo htmlspecialchars($notification['message']); ?></div>
                                    </div>
                                </a>
                            </li>
                        <?php endforeach; ?>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-center" href="notifications.php"><?php echo $lang_data['view_all']; ?></a></li>
                    <?php endif; ?>
                </ul>
            </li>
            
            <!-- User Menu -->
            <li class="nav-item dropdown">
                <button class="nav-link dropdown-toggle px-3 border-0 bg-transparent" type="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                    <i class="fas fa-user-circle me-1"></i>
                    <?php echo htmlspecialchars($currentUser['name']); ?>
                </button>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="userDropdown">
                    <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i><?php echo $lang_data['profile']; ?></a></li>
                    <li><a class="dropdown-item" href="settings.php"><i class="fas fa-cog me-2"></i><?php echo $lang_data['settings']; ?></a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="../index.php"><i class="fas fa-home me-2"></i><?php echo $lang_data['view_site']; ?></a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i><?php echo $lang_data['logout']; ?></a></li>
                </ul>
            </li>
        </div>
    </header>