<!-- Footer -->
    <footer class="admin-footer mt-auto py-3 bg-dark text-white">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-6">
                    <p class="mb-0">&copy; <?php echo date('Y'); ?> <?php echo SITE_NAME; ?>. <?php echo $lang_data['all_rights_reserved']; ?></p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">
                        <span class="me-2"><?php echo $lang_data['admin_version']; ?>: 1.0.0</span>
                        <span><a href="mailto:<?php echo ADMIN_EMAIL; ?>" class="text-white"><?php echo $lang_data['need_help']; ?></a></span>
                    </p>
                </div>
            </div>
        </div>
    </footer>

    <!-- Confirmation Modal -->
    <div class="modal fade" id="confirmationModal" tabindex="-1" aria-labelledby="confirmationModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="confirmationModalLabel"><?php echo $lang_data['confirm_action']; ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body" id="confirmationModalBody">
                    <?php echo $lang_data['confirm_action_message']; ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo $lang_data['cancel']; ?></button>
                    <a href="#" class="btn btn-danger" id="confirmActionBtn"><?php echo $lang_data['confirm']; ?></a>
                </div>
            </div>
        </div>
    </div>

    <!-- Toast for notifications -->
    <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 11">
        <div id="adminToast" class="toast hide" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="toast-header">
                <i class="fas fa-info-circle me-2 text-primary"></i>
                <strong class="me-auto" id="toastTitle"><?php echo $lang_data['notification']; ?></strong>
                <small id="toastTime">Just now</small>
                <button type="button" class="btn-close" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
            <div class="toast-body" id="toastMessage">
                <!-- Toast message goes here -->
            </div>
        </div>
    </div>

    <!-- Bootstrap JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.0/js/bootstrap.bundle.min.js"></script>
    
    <!-- jQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    
    <!-- Chart.js -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.7.0/chart.min.js"></script>
    
    <!-- Fullcalendar -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/fullcalendar/6.1.8/index.global.min.js"></script>
    
    <!-- DataTables -->
    <script src="https://cdn.datatables.net/1.13.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.5/js/dataTables.bootstrap5.min.js"></script>
    
    <!-- Summernote -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/summernote/0.8.20/summernote-bs5.min.js"></script>
    
    <!-- Custom Admin JS -->
    <script src="../js/admin-language.js"></script>
    <script src="../js/admin-charts.js"></script>
    <script src="../js/admin-calendar.js"></script>
    <script src="../js/admin.js"></script>
    
    <?php if (isset($additionalJs)): ?>
        <?php foreach ($additionalJs as $js): ?>
            <script src="<?php echo $js; ?>"></script>
        <?php endforeach; ?>
    <?php endif; ?>
    
    <?php if (isset($inlineJs)): ?>
        <script>
            <?php echo $inlineJs; ?>
        </script>
    <?php endif; ?>
    
    <script>
        // Initialize DataTables
        $(document).ready(function() {
            $('.datatable').DataTable({
                language: {
                    url: '../js/dataTables.<?php echo $lang; ?>.json'
                }
            });
            
            // Initialize Summernote rich text editor for any .summernote elements
            $('.summernote').summernote({
                height: 300,
                toolbar: [
                    ['style', ['style']],
                    ['font', ['bold', 'underline', 'clear']],
                    ['color', ['color']],
                    ['para', ['ul', 'ol', 'paragraph']],
                    ['table', ['table']],
                    ['insert', ['link', 'picture']],
                    ['view', ['fullscreen', 'codeview', 'help']]
                ]
            });
            
            // Initialize confirmation modals
            $('.confirm-action').on('click', function(e) {
                e.preventDefault();
                const targetUrl = $(this).attr('href');
                const message = $(this).data('message') || '<?php echo $lang_data['confirm_action_message']; ?>';
                
                $('#confirmationModalBody').text(message);
                $('#confirmActionBtn').attr('href', targetUrl);
                
                const confirmModal = new bootstrap.Modal(document.getElementById('confirmationModal'));
                confirmModal.show();
            });
            
            // Show toast notification if needed
            <?php if (isset($_SESSION['admin_toast_message'])): ?>
                showToast('<?php echo addslashes($_SESSION['admin_toast_title'] ?? $lang_data['notification']); ?>', 
                         '<?php echo addslashes($_SESSION['admin_toast_message']); ?>');
                <?php 
                // Clear the toast message
                unset($_SESSION['admin_toast_title']);
                unset($_SESSION['admin_toast_message']);
                ?>
            <?php endif; ?>
        });
        
        // Function to show toast notifications
        function showToast(title, message) {
            $('#toastTitle').text(title);
            $('#toastMessage').text(message);
            $('#toastTime').text('Just now');
            
            const toast = new bootstrap.Toast(document.getElementById('adminToast'));
            toast.show();
        }
    </script>
</body>
</html>
